# -*- coding: utf-8 -*-
"""
-------------------------------------------------
Задача C4-106.
Решение на языке Python 3.
-------------------------------------------------
106) (Е.А. Мирончик) 
На столе выложили цепочку из N костяшек по принципу 
домино. Под костяшкой понимается пара любых неотрицательных 
чисел, каждое не превышает 100. В наборе нет двух одинаковых 
костяшек (как в домино). Переставлять местами костяшки 
нельзя, но можно поворачивать любую костяшку, получая из 
костяшки 1-2 костяшку 2-1. Определите максимально длинную 
цепочку костяшек домино, которую можно получить. Под цепочкой 
следует понимать последовательность костяшек у которой второе 
число первой костяшки равно первому числу второй.
Описание входных и выходных данных
Входные данные: в первой строке задается число N – количество 
выложенных костяшек (0<N<10000). Далее следуют N пар чисел по два в строке. Программа должна вывести одно чис-ло – максимальную длину цепочки.
Пример входных данных:
5
1 2
2 3
5 4
5 5
5 1
Пример выходных данных для приведенного выше примера 
входных данных:
3
Пояснение: если перевернуть третью костяшку, то образуется 
цепочка: 4-5 5-5 5-1. 
"""
import sys
save_stdin = sys.stdin
sys.stdin = open("in/106.in")

maxLen = 1 # maxLen - длина максимальной цепочки
curLen = 1 # curLen - длина последней цепочки

n = int(input()) 
L = list(map(int, input().split()))
for i in range(1,n):
  R = list(map(int, input().split()))
  if L[1] == R[0]: # костяшка продолжает цепочку
    curLen += 1 
  elif L[1] == R[1]: # продолжает, но после поворота
    R = R[::-1] 
    curLen += 1 
  else:
    L = L[::-1] # переворот последней костяшки построенной ранее цепочки
    if L[1] == R[0]: # продолжение возможно 
      curLen = 2 
    elif L[1] == R[1]: # продолжение после поворота
      R = R[::-1] 
      curLen = 2 
    else:
      curLen = 1 # костяшка начинает новую цепочку 
  if curLen > maxLen: 
    maxLen = curLen 
  L = R 

print( maxLen )

sys.stdin = save_stdin