﻿# -*- coding: utf-8 -*-
"""
-------------------------------------------------
Задача C4-49. 
Решение на языке Python 3.
 Автор: Константин Поляков, 2013
E-mail: kpolyakov@mail.ru
   Web: kpolyakov.spb.ru
-------------------------------------------------
Дан список точек плоскости с целочисленными координатами. Необходимо 
определить:
1) номер координатной четверти K, в которой находится больше всего точек;
2) точку A в этой четверти, наименее удалённую от осей координат;
3) расстояние R от этой точки до ближайшей оси.
Если в нескольких четвертях расположено одинаковое количество точек,
следует выбрать ту четверть, в которой величина R меньше. При равенстве 
и количества точек, и величины R необходимо выбрать четверть с меньшим
номером K. Если в выбранной четверти несколько точек находятся на
одинаковом минимальном расстоянии от осей координат, нужно выбрать
первую по списку. Точки, хотя бы одна из координат которых равна нулю,
считаются не принадлежащими ни одной четверти и не рассматриваются.
Напишите эффективную, в том числе по памяти, программу, которая будет
решать эту задачу. 
Описание входных данных
В первой строке вводится одно целое положительное число – количество
точек N. Каждая из следующих N строк содержит координаты очередной точки
– два целых числа (первое – координата x, второе – координата y). 
Описание выходных данных
Программа должна вывести номер выбранной четверти K, количество точек в
ней M, координаты выбранной точки A и минимальное расстояние R по
образцу, приведённому ниже в примере.
Пример входных данных:
    7
    -3 4
    1 2
    1 1
    0 4
    -2 -3
    -6 8
    -12 1
Пример выходных данных для приведённого выше примера входных данных:
    K = 2
    M = 3
    A = (-12, 1)
    R = 1
"""
import sys
save_stdin = sys.stdin
sys.stdin = open("in/49.in")

N = int(input())
count = [0] * 4; R = [0] * 4
xR = [0] * 4; yR = [0] * 4
for i in range(N):
    x, y = [int(x) for x in input().split()] 
    if x*y != 0:
        if x > 0 and y > 0: k = 0
        elif x < 0 and y > 0: k = 1 
        elif x < 0 and y < 0: k = 2 
        else: k = 3
        count[k] += 1
        if count[k] == 1 or abs(x) < R[k] or abs(y) < R[k]:
            R[k] = min( abs(x), abs(y) ) 
            xR[k] = x 
            yR[k] = y   

k = 0
for i in range(1, 4):
  if count[i] > count[k] or (count[i] == count[k] and R[i] < R[k]):
    k = i
print('K =', k+1)
print('M =', count[k])
print('A = (%d,%d)' % (xR[k], yR[k]) )
print('R =', R[k])

sys.stdin = save_stdin