# -*- coding: utf-8 -*-
"""
-------------------------------------------------
Задача C4-53. 
Решение на языке Python 3.
 Автор: Константин Поляков, 2014
E-mail: kpolyakov@mail.ru
   Web: kpolyakov.spb.ru
-------------------------------------------------
Гоночная трасса состоит из двух основных дорог и нескольких 
переездов, позволяющих перейти с одной дороги на другую. 
 
На всех участках, включая переезды, движение разрешено только 
в одну сторону, поэтому переезд возможен только с дороги A на 
дорогу B. Гонщик стартует в точке A0 и должен финишировать в 
точке BN. Он знает, за какое время сможет пройти каждый участок пути по каждой дороге, то есть время прохождения участков A0A1, A1A2, ..., AN-1AN, B0B1, B1B2, ..., BN-1BN. Время прохождения всех переездов A0B0, A1B1, ..., ANBN одинаково и известно гонщику.  Необходимо определить, за какое минимальное время гонщик сможет пройти трассу.
Напишите эффективную, в том числе по используемой памяти, 
программу для решения этой задачи. Перед текстом программы 
кратко опишите алгоритм решения и укажите язык программирования
и его версию.
Входные данные
В первой строке задаётся количество участков трассы N. 
Во второй строке задаётся целое число t – время (в секундах) 
прохождения каждого из переездов A0B0, A1B1, …, ANBN. В каждой 
из последующих N строк записано два целых числа ai и bi, 
задающих время (в секундах) прохождения очередного участка 
на каждой из дорог. В первой из этих строк указывается время 
прохождения участков A0A1 и B0B1, во второй – A1A2 и B1B2 и 
т. д.
Пример входных данных
3
20
320 150
200 440
300 210
Выходные данные
Программа должна напечатать одно целое число: минимально возможное
время прохождения трассы (в секундах).
Пример выходных данных для приведённого выше примера входных данных
750
"""
import sys
save_stdin = sys.stdin
sys.stdin = open("in/53.in")

"""
Плохое решение:

N = int(input())
t = int(input())
A, B = [], []
for i in range(N):
  a, b = map(int, input().split())
  print ( a, b )
  A.append(a)
  B.append(b)

SA = [0] + A[:]
for i in range(1,N+1):
  SA[i] = SA[i] + SA[i-1]

SB = B[:] + [0]
for i in range(N-2,-1,-1):
  SB[i] = SB[i] + SB[i+1]

TB = t + SB[0]
for i in range(1,N+1):
  Ti = SA[i] + t + SB[i]  
  if Ti < TB: TB = Ti

"""
N = int(input())
t = int(input())
TA, TB = 0, t
for i in range(N):
  a, b = map(int, input().split())
  TA, TB = TA+a, min(TA+a+t, TB+b)

print(TB)

sys.stdin = save_stdin