# -*- coding: utf-8 -*-
"""
-------------------------------------------------
Задача C4-56. 
Решение на языке Python 3.
 Автор: Константин Поляков, 2014
E-mail: kpolyakov@mail.ru
   Web: kpolyakov.spb.ru
-------------------------------------------------
На спутнике «Фотон» установлен прибор, предназначенный для измерения 
энергии космических лучей. Каждую минуту прибор передаёт по каналу связи
неотрицательное вещественное число – количество энергии, полученной за
последнюю минуту, измеренное в условных единицах. Временем, в течение
которого происходит передача, можно пренебречь. Необходимо найти в заданной
серии показаний прибора минимальное произведение двух показаний, между
моментами передачи которых прошло не менее 6 минут. Количество энергии,
получаемое прибором за минуту, не превышает 1000 условных единиц. Общее 
количество показаний прибора в серии не превышает 10 000. 
Напишите на любом языке программирования программу для решения поставленной
задачи. Программа должна вывести одно число – описанное в условии произведение.
Программа считается эффективной по времени, если время работы программы
пропорционально количеству полученных показаний прибора N, т.е. при
увеличении N в k раз время работы программы должно увеличиваться не более чем
в k раз.
Программа считается эффективной по памяти, если размер памяти, использованной
в программе для хранения данных, не зависит от числа N и не превышает 1
килобайта. 
В первой строке задаётся число N – общее количество показаний прибора.
Гарантируется, что N > 6. В каждой из следующих N строк задаётся одно 
неотрицательное вещественное число – очередное показание прибора. 
Пример входных данных:
11
12
45
5
4
25
23
21
20
10
12
26
Пример выходных данных для приведённого выше примера входных данных:
48
"""
import sys
save_stdin = sys.stdin
sys.stdin = open("in/56.in")

N = int(input())
K = 6
Buf = [0]*K
minPrev = 1001
minRes = 1000*1000 + 1
for i in range(N):
  if i >= K:
    minPrev = min(minPrev, Buf[i % K])
  Buf[i % K] = int(input())
  minRes = min(minRes, minPrev*Buf[i % K])

print(minRes)

sys.stdin = save_stdin