# -*- coding: utf-8 -*-
"""
-------------------------------------------------
Задача C4-74. 
Решение на языке Python 3.
 Автор: Павел Енин, 2017
-------------------------------------------------
74) (Д.Ф. Муфаззалов) Имеется набор данных, состоящий 
из троек натуральных чисел. Необходимо выбрать из каждой 
тройки два числа так, чтобы сумма всех выбранных чисел 
была кратна 4 и при этом была максимально возможной. 
Если получить требуемую сумму невозможно, в качестве 
ответа нужно выдать 0. 
Входные данные:
На вход программе в первой строке подаётся количество 
троек N (1 <= N <= 100000). Каждая из следующих N строк 
содержит три натуральных числа, не превышающих 10 000.
  6
  8 3 4
  4 8 12
  9 5 6
  2 8 3
  12 3 5
  1 4 12
Пример выходных данных для приведённого 
примера входных данных: 
  88
"""
import sys
save_stdin = sys.stdin
sys.stdin = open("in/74.in")

s = 0 # сумма выбранных чисел
delta = [10000]*3 # список попарных разностей
for i in range(int(input())): #построчно обрабатываем поток троек чисел
    num_list = [int(x) for x in input().split()] # список из очередной тройки чисел
    mi = min(num_list) 
    s += sum(num_list) - mi # добавлям пару с наибольшей суммой
    for num in num_list: # проверка разностей всех парных комбинаций в тройке на остаток от деления на 4 
        if (num - mi) % 4 == 1: # минимальная разность между 2-я парами чисел, остаток от деления которой на 4 равен 1
            delta[0] = min(num - mi, delta[0]) 
        elif (num - mi) % 4 == 2: # минимальная разность между 2-я парами чисел, остаток от деления которой на 4 равен 2
            delta[1] = min(num - mi, delta[1])
        elif (num - mi) % 4 == 3: # минимальная разность между 2-я парами чисел, остаток от деления которой на 4 равен 3
            delta[2] = min(num - mi, delta[2])         
if s % 4: # если итоговая сумма не делится на 4 
    s -= delta[s % 4 - 1] if delta[s % 4 - 1] < 10000 else s # вычитаем минимальную дельту с таким же остатком или обнуляем сумму
print(s)

sys.stdin = save_stdin