# -*- coding: utf-8 -*-
"""
-------------------------------------------------
Задача C4-74. 
Решение на языке Python 3.
 Автор: Евгений Жеглов, 2017
-------------------------------------------------
74) (Д.Ф. Муфаззалов) Имеется набор данных, состоящий 
из троек натуральных чисел. Необходимо выбрать из каждой 
тройки два числа так, чтобы сумма всех выбранных чисел 
была кратна 4 и при этом была максимально возможной. 
Если получить требуемую сумму невозможно, в качестве 
ответа нужно выдать 0. 
Входные данные:
На вход программе в первой строке подаётся количество 
троек N (1 <= N <= 100000). Каждая из следующих N строк 
содержит три натуральных числа, не превышающих 10 000.
  6
  8 3 4
  4 8 12
  9 5 6
  2 8 3
  12 3 5
  1 4 12
Пример выходных данных для приведённого 
примера входных данных: 
  88
"""
import sys
save_stdin = sys.stdin
sys.stdin = open("in/74.in")

n = int(input())
x = [0]*4            # две таблицы размером 4х1
y = [0]*4
inp = list(map(int, input().split()))  #считываем первую тройку 
for i in range(3):     # три варианта различных сумм
  a = inp[i] + inp[(i+1)%3]  #inp0+inp1; inp1+inp2; inp2+inp0
  if y[a % 4] < a:    #записываем максимальное значение          
    y[a % 4] = a      #индекс = остатку от деления на 4
for j in range(n-1): 
  for i in range(4):
    x[i] = y[i] #скопируем значения второй таблицы в первую,
    y[i] = 0    #а значения второй обнулим
  inp = list(map(int,input().split())) #считаем очередную тройку
  for i in range (4):
    if x[i]!=0:  #для каждой суммы, найденной на предыдущем шаге 
      for k in range(3): #найдем все три варианта значений
                         #новой суммы (с учетом последних чисел)
        a = x[i]+inp[k]+inp[(k+1)%3]   
        if y[a % 4] < a: #и запишем максимум в ячейку
          y[a % 4] = a   #с индексом a%4

print(y[0])

sys.stdin = save_stdin