# -*- coding: utf-8 -*-
"""
-------------------------------------------------
Задача C4-102.
Решение на языке Python 3.
-------------------------------------------------
102) (А.Г. Минак) На вход программы поступает последовательность 
из N целых положительных чисел, все числа в последовательности 
различны. Рассматриваются все пары различных элементов 
последовательности, находящихся на расстоянии не больше 
чем 7 (разница в индексах элементов пары должна быть 7 или менее, 
порядок элементов в паре неважен). Необходимо определить 
количество таких пар, для которых сумма элементов не делится на 8.
Описание входных и выходных данных
В первой строке входных данных задаётся количество чисел 
N (8 ≤ N ≤ 1000). В каждой из последующих N строк записано 
одно целое положительное число, не превышающее 10 000.
В качестве результата программа должна вывести одно число: 
количество пар элементов, находящихся в последовательности 
на расстоянии не более чем 7, в которых сумма элементов не кратна 8.
Пример входных данных:
10
17 
4   
1   
8   
3 
12 
16  
4   
5  
11
Пример выходных данных для приведённого выше примера 
входных данных:
36
Пояснение. Из десяти заданных элементов с учётом допустимых 
расстояний между ними можно составить 42 суммы: 17+4, 17+1, 
17+8, 17+3, 17+12, 17+16, 17+4, 4+1, 4+8, ..., 16+4, 16+5, 
16+11, 4+5, 4+11, 5+11. Из них на 8 не делятся 36 сумм.
"""
import sys
save_stdin = sys.stdin
sys.stdin = open("in/102.in")

N = int(input())
buf = [0] * 8
rem_div = [0] * 8

for i in range(8):
     buf[i] = int(input())
     rem_div[buf[i]%8] += 1
     
cnt = (rem_div[0] * (rem_div[0] - 1)) // 2
cnt += (rem_div[4] * (rem_div[4] - 1)) // 2
for i in range(1, 4):
     cnt += rem_div[i] * rem_div[8-i]
     
for _ in range(8, N):
     rem_div[buf[0]%8] -= 1
     buf.pop(0)
     
     x = int(input())
     d = x % 8

     if d == 0:
          cnt += rem_div[0]
     elif d == 4:
          cnt += rem_div[4]
     else:
          cnt += rem_div[8 - d]

     buf.append(x)
     rem_div[d] += 1

all_ = 7 * (N - 8) + (8 * (8 - 1)) // 2
    
print(all_ - cnt)  

sys.stdin = save_stdin