# -*- coding: utf-8 -*-
"""
-------------------------------------------------
Задача C4-112.
Решение на языке Python 3.
-------------------------------------------------
112) (Е. Джобс) На вход программы поступает последовательность 
из N целых положительных чисел, все числа в последовательности 
различны. Рассматриваются все пары различных элементов 
последовательности, находящихся на расстоянии не меньше 4 
(разница в индексах элементов пары должна быть 4 или более, 
порядок элементов в паре неважен). Необходимо определить 
количество таких пар, для которых сумма элементов кратна 8.
Описание входных и выходных данных
В первой строке входных данных задаётся количество чисел N (5 ≤ N ≤ 1000). В каждой из после-дующих N строк записано одно целое положительное число, не превышающее 10 000. 
В качестве результата программа должна вывести одно число: количество пар элементов, нахо-дящихся в последовательности на расстоянии не меньше 4, в которых сумма элементов кратна 8.
Входные данные: 
7 
1 
5 
9 
8 
15 
23 
31
Выходные данные: 
4
Найденные пары: (1,15) (1,23) (1,31) (9,31)
"""
import sys
save_stdin = sys.stdin
sys.stdin = open("in/112.in")

d = 4
n = int(input())
ost = [0]*8

buf = []
for i in range(d):
  buf.append(int(input()))

count = 0
for i in range(n-d):
  first = buf[i % d]
  k = first % 8
  ost[k] += 1
  x = int(input())
  k = x % 8
  dk = (8 - k) % 8  # парный остаток
  count += ost[dk]
  buf[i % d] = x
  
print(count)

sys.stdin = save_stdin