﻿# -*- coding: utf-8 -*-
"""
-------------------------------------------------
Задача C4-47. 
Решение на языке Python 3.
 Автор: Константин Поляков, 2013
E-mail: kpolyakov@mail.ru
   Web: kpolyakov.spb.ru
-------------------------------------------------
На плоскости дан набор точек с целочисленными координатами. Необходимо 
найти такой треугольник наибольшей площади с вершинами в этих точках, у
которого нет общих точек с осью Оу, а одна из сторон лежит на оси Ох.
Напишите эффективную, в том числе по памяти, программу, которая будет
решать эту задачу. Размер памяти, которую использует Ваша программа, не
должен зависеть от количества точек.
Перед текстом программы кратко опишите используемый алгоритм решения
задачи и укажите используемый язык программирования и его версию.
Описание входных данных
В первой строке вводится одно целое положительное число - количество
точек N.
Каждая из следующих N строк содержит два целых числа - сначала
координата х, затем координата у очередной точки. Числа разделены 
пробелом.
Описание выходных данных
Программа должна вывести одно число - максимальную площадь треугольника,
удовлетворяющего условиям задачи. Если такого треугольника не
существует, программа должна вывести ноль.
Пример входных данных:
    8
    -10 0
    2 0
    0 4
    3 3
    7 0
    5 5
    4 0
    9 -9
Пример выходных данных для приведённого выше примера входных данных:
    22.5
"""
import sys
save_stdin = sys.stdin
sys.stdin = open("in/47.in")

N = int(input())
xMin1 = None; xMax1 = 0; yMax1 = 0
xMin2 = None; xMax2 = 0; yMax2 = 0
for i in range(N):
    x, y = [int(v) for v in input().split()]
    if x < 0:
        if y == 0:
            if xMin1 == None or x < xMin1: 
                xMin1 = x
            if x > xMax1: xMax1 = x
        else: 
            yMax1 = max( abs(y), yMax1 )
    elif x > 0:
        if y == 0:
            if xMin2 == None or x < xMin2: 
                xMin2 = x
            if x > xMax2: xMax2 = x
        else: 
            yMax2 = max( abs(y), yMax2 )
S1 = (xMax1 - xMin1) * yMax1 / 2.
S2 = (xMax2 - xMin2) * yMax2 / 2.
print(max(S1,S2))

sys.stdin = save_stdin