# -*- coding: utf-8 -*-
"""
-------------------------------------------------
Задача C4-72. 
Решение на языке Python 3.
 Автор: Константин Поляков, 2017
E-mail: kpolyakov@mail.ru
   Web: kpolyakov.spb.ru
-------------------------------------------------
72) (Д.Ф. Муфаззалов) Имеется набор данных, состоящий 
из пар положительных целых чисел. Для каждой пары чисел 
находится значение А – наибольший общий делитель. Напишите 
эффективную по времени работы и по используемой памяти 
программу, которая будет определять, какое значение А 
встречалось чаще всего. Если несколько значений А встречалось 
одинаковое наибольшее количество раз, вывести их в порядке 
убывания.
Программа считается эффективной по времени, если время 
работы программы пропорционально количеству пар чисел N, 
т. е. при увеличении N в k раз время работы программы должно 
увеличиваться не более чем в k раз. Программа считается 
эффективной по памяти, если размер памяти, использованной 
в программе для хранения данных, не зависит от числа N и 
не превышает 100 килобайт.
Входные данные:
На вход программе в первой строке подаётся количество пар 
N (1 <= N <= 100000). Каждая из следующих N строк содержит 
два натуральных числа, не превышающих 1000. 
Пример входных данных: 
  6
  1 3 
  5 15  
  6 9  
  5 4  
  3 3  
  36 40  
Пример выходных данных для приведённого примера входных данных: 
  3 1
"""
import sys
save_stdin = sys.stdin
sys.stdin = open("in/72.in")

count = [0]*1001
N = int(input())
for i in range(N):  
  num1, num2 = map(int, input().split())
  while num2 > 0: 
    num2, num1 = num1 % num2, num2
  count[num1] += 1

maximum = max(count)
iMax = [i for i in range(1,1001) if count[i] == maximum]
for c in iMax[::-1]:
  print(c, end=' ')

sys.stdin = save_stdin